﻿using System;
using System.Collections.Generic;
using System.Text;

namespace IMMeDotNet {

	/// <summary>
	/// Common error codes.
	/// </summary>
	enum Error : byte {
		/// <summary>
		/// No error.
		/// </summary>
		OK = 0x00,
		/// <summary>
		/// You are not in contact's friend list.
		/// </summary>
		NotInFriendList = 0xF9,
		/// <summary>
		/// Contact has logged off.
		/// </summary>
		ContactHasLoggedOff = 0xFA,
		/// <summary>
		/// Screen name has expired.
		/// </summary>
		ScreenNameHasExpired = 0xFC,
		/// <summary>
		/// Incorrect password entered.
		/// </summary>
		IncorrectPassword = 0xFD,
	}
}
